	% This Matlab script adds pi's to the x-axis tick label elements whenever
	% it is seen appropriate
	% Tapio 27.9.2018
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 2018-09-27
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	xticks = get(gca,'XTickLabel');
	pos = get(gca,'XTick');
	inx1 = find(abs(1-pos)<10^-10);
	inx2 = find(pos == 0);
	l = size(xticks);
	l = l(1);
	for K = 1:l
		if ~isempty(inx1) & K == inx1
			xticks{K}=['\pi'];
		elseif ~isempty(inx2) & (K == inx2)
			xticks{K}=[xticks{K}];
		else
			xticks{K}=[xticks{K} '\pi'];
		end
	end
	set(gca,'XTickLabel',xticks) % set tick labels to updated values
	
